SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Databáze: `rozvrh`
--

-- --------------------------------------------------------

--
-- Struktura tabulky `mistnosti`
--

CREATE TABLE `mistnosti` (
  `id` int(10) UNSIGNED NOT NULL,
  `nazev` varchar(60) COLLATE latin2_czech_cs NOT NULL DEFAULT '',
  `alt_nazev` varchar(32) COLLATE latin2_czech_cs DEFAULT NULL,
  `rezervace` enum('a','n') COLLATE latin2_czech_cs NOT NULL DEFAULT 'a',
  `nazac` enum('a','n') COLLATE latin2_czech_cs NOT NULL DEFAULT 'a',
  `smazano` enum('a','n') COLLATE latin2_czech_cs NOT NULL DEFAULT 'n'
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `odpadnuti`
--

CREATE TABLE `odpadnuti` (
  `datum` date NOT NULL DEFAULT '0000-00-00',
  `predmety_id` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `pocitace`
--

CREATE TABLE `pocitace` (
  `id` int(10) UNSIGNED NOT NULL,
  `mistnosti_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `nazev` varchar(32) COLLATE latin2_czech_cs NOT NULL DEFAULT '',
  `alt_nazev` varchar(32) COLLATE latin2_czech_cs NOT NULL DEFAULT '',
  `smazano` enum('a','n') COLLATE latin2_czech_cs NOT NULL DEFAULT 'n'
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `predmety`
--

CREATE TABLE `predmety` (
  `id` int(10) UNSIGNED NOT NULL,
  `nazev` varchar(255) COLLATE latin2_czech_cs NOT NULL DEFAULT '',
  `poznamka` varchar(255) COLLATE latin2_czech_cs NOT NULL DEFAULT '',
  `platnost_od` date NOT NULL DEFAULT '0000-00-00',
  `platnost_do` date NOT NULL DEFAULT '0000-00-00',
  `den` smallint(5) UNSIGNED NOT NULL DEFAULT '0',
  `cas_od` time NOT NULL DEFAULT '00:00:00',
  `cas_do` time NOT NULL DEFAULT '00:00:00',
  `perioda` enum('s','l','t') COLLATE latin2_czech_cs NOT NULL DEFAULT 's',
  `vyucujici` int(10) UNSIGNED DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `predmety_kontakty`
--

CREATE TABLE `predmety_kontakty` (
  `id` int(10) UNSIGNED NOT NULL,
  `predmety_id` int(10) UNSIGNED NOT NULL,
  `kontakty_id` int(10) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `predmety_mistnosti`
--

CREATE TABLE `predmety_mistnosti` (
  `predmety_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `mistnosti_id` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `predmety_pocitace`
--

CREATE TABLE `predmety_pocitace` (
  `predmety_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `pocitace_id` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `rezervace`
--

CREATE TABLE `rezervace` (
  `id` int(10) UNSIGNED NOT NULL,
  `nazev` varchar(255) COLLATE latin2_czech_cs NOT NULL DEFAULT '',
  `poznamka` varchar(255) COLLATE latin2_czech_cs NOT NULL DEFAULT '',
  `datum` date NOT NULL DEFAULT '0000-00-00',
  `cas_od` time NOT NULL DEFAULT '00:00:00',
  `cas_do` time NOT NULL DEFAULT '00:00:00',
  `zadal` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `rezervace_kontakty`
--

CREATE TABLE `rezervace_kontakty` (
  `id` int(10) UNSIGNED NOT NULL,
  `rezervace_id` int(10) UNSIGNED NOT NULL,
  `kontakty_id` int(10) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `rezervace_mistnosti`
--

CREATE TABLE `rezervace_mistnosti` (
  `rezervace_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `mistnosti_id` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

-- --------------------------------------------------------

--
-- Struktura tabulky `rezervace_pocitace`
--

CREATE TABLE `rezervace_pocitace` (
  `rezervace_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `pocitace_id` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_czech_cs;

--
-- Klíče pro exportované tabulky
--

--
-- Klíče pro tabulku `mistnosti`
--
ALTER TABLE `mistnosti`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `odpadnuti`
--
ALTER TABLE `odpadnuti`
  ADD PRIMARY KEY (`datum`,`predmety_id`);

--
-- Klíče pro tabulku `pocitace`
--
ALTER TABLE `pocitace`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `predmety`
--
ALTER TABLE `predmety`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `nazev` (`nazev`,`platnost_od`,`platnost_do`,`den`,`cas_od`,`cas_do`,`perioda`,`vyucujici`);

--
-- Klíče pro tabulku `predmety_kontakty`
--
ALTER TABLE `predmety_kontakty`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `predmety_mistnosti`
--
ALTER TABLE `predmety_mistnosti`
  ADD PRIMARY KEY (`predmety_id`,`mistnosti_id`);

--
-- Klíče pro tabulku `predmety_pocitace`
--
ALTER TABLE `predmety_pocitace`
  ADD PRIMARY KEY (`predmety_id`,`pocitace_id`);

--
-- Klíče pro tabulku `rezervace`
--
ALTER TABLE `rezervace`
  ADD PRIMARY KEY (`id`),
  ADD KEY `nazev` (`nazev`,`datum`,`cas_od`,`cas_do`,`zadal`);

--
-- Klíče pro tabulku `rezervace_kontakty`
--
ALTER TABLE `rezervace_kontakty`
  ADD PRIMARY KEY (`id`);

--
-- Klíče pro tabulku `rezervace_mistnosti`
--
ALTER TABLE `rezervace_mistnosti`
  ADD PRIMARY KEY (`rezervace_id`,`mistnosti_id`);

--
-- Klíče pro tabulku `rezervace_pocitace`
--
ALTER TABLE `rezervace_pocitace`
  ADD PRIMARY KEY (`rezervace_id`,`pocitace_id`);

--
-- AUTO_INCREMENT pro tabulky
--

--
-- AUTO_INCREMENT pro tabulku `mistnosti`
--
ALTER TABLE `mistnosti`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=55;
--
-- AUTO_INCREMENT pro tabulku `pocitace`
--
ALTER TABLE `pocitace`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;
--
-- AUTO_INCREMENT pro tabulku `predmety`
--
ALTER TABLE `predmety`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=16373;
--
-- AUTO_INCREMENT pro tabulku `predmety_kontakty`
--
ALTER TABLE `predmety_kontakty`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5225;
--
-- AUTO_INCREMENT pro tabulku `rezervace`
--
ALTER TABLE `rezervace`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=54363;
--
-- AUTO_INCREMENT pro tabulku `rezervace_kontakty`
--
ALTER TABLE `rezervace_kontakty`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=19247;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
